/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsFileReadPacket;
import com.ibm.hsc.filesvr.FsFileReadResponsePacket;
import com.ibm.hsc.filesvr.FsPacket;

public class FsFileReadRequestPacket
extends FsFileReadPacket {
    public FsFileReadRequestPacket(FsConnection fsConnection) {
        super(fsConnection);
        this.setRequestPacket();
    }

    public FsFileReadRequestPacket(FsConnection fsConnection, long l, int n, long l2) {
        super(fsConnection, l, n, l2);
        this.setRequestPacket();
    }

    public FsFileReadRequestPacket(FsConnection fsConnection, long l, int n, int n2, long l2) {
        super(fsConnection, l, n, n2, l2);
        this.setRequestPacket();
    }

    public FsFileReadRequestPacket(FsConnection fsConnection, long l, int n, int n2, int n3, String string) {
        super(fsConnection, l, n, n2, n3, string);
        this.setRequestPacket();
    }

    public FsFileReadRequestPacket(FsPacket fsPacket) {
        super(fsPacket);
        this.setRequestPacket();
    }

    public FsFileReadRequestPacket(FsPacket fsPacket, long l, int n, long l2) {
        super(fsPacket, l, n, l2);
        this.setRequestPacket();
    }

    public FsFileReadRequestPacket(FsPacket fsPacket, long l, int n, int n2, long l2) {
        super(fsPacket, l, n, n2, l2);
        this.setRequestPacket();
    }

    public FsFileReadRequestPacket(FsPacket fsPacket, long l, int n, int n2, int n3, String string) {
        super(fsPacket, l, n, n2, n3, string);
        this.setRequestPacket();
    }

    public FsFileReadRequestPacket(FsFileReadPacket fsFileReadPacket) throws FsException {
        super(fsFileReadPacket);
        this.setRequestPacket();
    }

    public FsFileReadRequestPacket(FsFileReadRequestPacket fsFileReadRequestPacket) throws FsException {
        super(fsFileReadRequestPacket);
        this.setRequestPacket();
    }

    protected void buildData(FsByteStream fsByteStream) throws FsException {
        super.buildData(fsByteStream);
        if (!this.isRequestPacket()) {
            throw new FsException(20);
        }
        fsByteStream.writeInt(this.m_fileAction);
        fsByteStream.writeInt(this.m_readLength);
        fsByteStream.writeLong(this.m_readOffset);
        switch (this.m_fileAction) {
            case 0: 
            case 4: {
                fsByteStream.writeLong(this.m_fileHandle);
                break;
            }
            case 1: 
            case 5: {
                if (this.m_fileName == null || this.m_fileName.length() == 0) {
                    throw new FsException(21);
                }
                if (this.m_fileType != 1) {
                    throw new FsException(23, this.m_fileType);
                }
                fsByteStream.writeInt(this.m_fileType);
                fsByteStream.writeLong(this.m_fileName.length());
                fsByteStream.writeString(this.m_fileName);
                break;
            }
            default: {
                throw new FsException(28);
            }
        }
    }

    public FsPacket getResponsePacket() {
        return new FsFileReadResponsePacket(this);
    }

    protected void parseData(FsByteStream fsByteStream) throws FsException {
        super.parseData(fsByteStream);
        if (!this.isRequestPacket()) {
            throw new FsException(20);
        }
        this.m_fileAction = fsByteStream.readInt();
        this.m_readLength = fsByteStream.readInt();
        this.m_readOffset = fsByteStream.readLong();
        switch (this.m_fileAction) {
            case 0: 
            case 4: {
                this.m_fileHandle = fsByteStream.readLong();
                break;
            }
            case 1: 
            case 5: {
                this.m_fileType = fsByteStream.readInt();
                int n = (int)fsByteStream.readLong();
                this.m_fileName = fsByteStream.readString(n);
                if (this.m_fileName == null || this.m_fileName.length() == 0) {
                    throw new FsException(21);
                }
                if (this.m_fileType == 1) break;
                throw new FsException(23, this.m_fileType);
            }
            default: {
                throw new FsException(28);
            }
        }
    }
}

